import java.net.InetAddress;
import cnrg.itx.datax.PropertiesCollection;
import cnrg.itx.datax.devices.NetworkProperty;
import cnrg.itx.datax.DataException;
import java.util.Enumeration;

public class VirtualNetworkDestination extends NullDestination
{

	public InetAddress m_peer;
	public int m_port;
	
	public void setPeerProperties(PropertiesCollection pc) throws DataException
	{
		boolean bGotProperty = false;
		Object prop;
		
		for (Enumeration e = pc.getProperties(); e.hasMoreElements() ; )
		{
			prop = e.nextElement();
			
			if (prop instanceof NetworkProperty)
			{
				if (! bGotProperty)
				{
					m_port = ((NetworkProperty)prop).getPort();
					m_peer = ((NetworkProperty)prop).getAddress();
					bGotProperty = true;
				}
				else 
				{
					throw new DataException("More than 1 network source that we need to send data to!");
				}
			}
		}
	}
	
	public PropertiesCollection getProperties() {
		PropertiesCollection pc = new PropertiesCollection();
		pc.addProperty(new NetworkProperty(-1));
		return pc;
	}
}
